#ifndef MONSTER_H
#define MONSTER_H

#include <material.h>
#include <atomdir.h>
//#include <dactuator.h>
#include <mousedir.h>
#include "walker.h"
#include "arm.h"

struct Monster : public Material {
	bool *move_right;
	bool *move_left;
	bool *move_up;
	bool *move_down;
	double speed;
	AtomDir *forward;
	Walker *body;
	Arm *arm;
	double cur_punch;
	double punch_dir;
	MouseDir *arm_dir;
	int atoms_on_ground;
	int feet_on_ground;
	PhysList<Atom> center;
	int cooldown;
	bool jumped;
	int direction;	//1 or -1
	float *mouse_x;
	float *mouse_y;
	float health;
	bool alive;

	Monster(Object *parent, float *mouse_x, float *mouse_y, double speed, bool *move_right, bool *move_left, bool *move_up, bool *move_down, bool *grab, bool *punch);
	void die();
	virtual bool allowRepulse(Atom *a, Atom *b);
	virtual void onRepulse(Atom *a, Atom *b, float force);
	virtual void stepFunc();
	virtual void atomFunc(Atom *a);
	virtual void addAtom(Atom *a);
	virtual void addPoly(Poly *p);
	virtual void draw();
};

#endif